use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- Script 6600_66418
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_CreateSMSHistory]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_CreateSMSHistory]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_CreateSMSHistory]
    @id INT OUTPUT,
    @iDistributionId int,
    @iSurveyId int,
    @iRespondentId int,
    @nvcRecipientPhone nvarchar(32),
    @tiStatus tinyint,
    @nvcMessage nvarchar(MAX),
    @nvcMessageId nvarchar(400),
    @iOutgoingConfigId int
AS
BEGIN
   IF NOT EXISTS (SELECT * FROM [dbo].[Distributions_SMS_History] WITH(NOLOCK) WHERE [DistributionId] = @iDistributionId AND [RespondentId]=@iRespondentId and [Status]=@tiStatus)
   BEGIN
      INSERT INTO [dbo].[Distributions_SMS_History]
		    ([DistributionId]
		    ,[RespondentId]
		    ,[RecipientPhone]
		    ,[Status]
		    ,[TimeStamp]
		    ,[Message]
		    ,[MessageId]
		    ,[OutgoingConfigurationId])
	    VALUES
		    (@iDistributionId
		    ,@iRespondentId
		    ,@nvcRecipientPhone
		    ,@tiStatus
		    ,GETUTCDATE()
		    ,@nvcMessage
		    ,@nvcMessageId
		    ,@iOutgoingConfigId)
	    SET @id = SCOPE_IDENTITY();

	    DECLARE @iClientId int
	    SET @iClientId = dbo.GetClientId(DB_NAME())
	    DECLARE @vcProjectSchemaName VARCHAR(255)
	    SET @vcProjectSchemaName = ''Survey_'' + CONVERT(VARCHAR(10), @iClientId) + ''_'' + CONVERT(VARCHAR(10), @iSurveyId)

	    IF @tiStatus = 1
               EXEC(''UPDATE ['' + @vcProjectSchemaName + ''].[RespondentActivitySummary] SET PhoneStatus = '' + @tiStatus + '', SMSNumberSent = isnull(SMSNumberSent, 0) + 1 WHERE RespondentId = '' + @iRespondentId )
	    ELSE
               EXEC(''UPDATE ['' + @vcProjectSchemaName + ''].[RespondentActivitySummary] SET PhoneStatus = '' + @tiStatus + '' WHERE RespondentId = '' + @iRespondentId )
   END
   ELSE
   BEGIN
        SET @id = -1;
   END
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone